﻿/*	VERSION:	1.1
1.1		Now uses .getBounds() for compatibility with movieClips whose origin is not located at their top-left corner.

USAGE:
	#include "functions/hitClip.as"
	react.to("onDropFiles").from(dropFileEvents).then = function( evt )	{
		if(  !hitClip( {x:_root._xmouse,y:_root._ymouse}, bg )  )		return;
		
		if( !hitClip( evt.mouse, bg ) )		return;
		// do stuff
	}// onDropFiles()
*/
function getClipRect( clip, relativeTo ){
	var relativeTo = relativeTo || _root;
	// size
	var ww = clip.width || clip._width;
	var hh = clip.height || clip._height;
	// top-left corner
	if( clip.getBounds ){
		var bounds = clip.getBounds( relativeTo );
		var topLeft = new flash.geom.Point( bounds.xMin, bounds.yMin );
	}else{
		var xx = (clip.x !== undefined) ? clip.x : clip._x;
		var yy = (clip.y !== undefined) ? clip.y : clip._y;
		var topLeft = new flash.geom.Point(xx,yy);
	}
	// convert  topLeft + size  =>  Rectangle
	var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
	return output_rect;
}// getClipRect()


function hitClip( coords_p, clip ){
	var rect = getClipRect( clip, _root );
	var output = rect.containsPoint( coords_p );
	//mdm.Exception.DebugWindow.trace("hitting "+clip._name+": "+output+"   rect: "+rect);
	return output;
}// hitClip()